﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{


    public class QuotationsDetailsDB
    {
        public static QuotationsDetails GetItem(Guid quotationsDetailsID, Guid quotationsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsDetailsID", ((quotationsDetailsID != Guid.Empty && quotationsDetailsID != null) ? quotationsDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@QuotationsID", ((quotationsID != Guid.Empty && quotationsID != null) ? quotationsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<QuotationsDetails>("spGetQuotationsDetails", parameters);
        }

        public static List<QuotationsDetails> GetList(Guid quotationsDetailsID, Guid quotationsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsDetailsID", ((quotationsDetailsID != Guid.Empty && quotationsDetailsID != null) ? quotationsDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@QuotationsID", ((quotationsID != Guid.Empty && quotationsID != null) ? quotationsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<QuotationsDetails>("spGetQuotationsDetails", parameters);

        }

        public static DataTable GetDataTable(Guid quotationsDetailsID, Guid quotationsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsDetailsID", ((quotationsDetailsID != Guid.Empty && quotationsDetailsID != null) ? quotationsDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@QuotationsID", ((quotationsID != Guid.Empty && quotationsID != null) ? quotationsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetQuotationsDetails", parameters);
        }

        public static DataSet GetDataSet(Guid quotationsDetailsID, Guid quotationsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsDetailsID", ((quotationsDetailsID != Guid.Empty && quotationsDetailsID != null) ? quotationsDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@QuotationsID", ((quotationsID != Guid.Empty && quotationsID != null) ? quotationsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetQuotationsDetails", parameters);
        }

        public static void Save(QuotationsDetails myQuotationsDetails)
        {
            myQuotationsDetails.Mode = ((myQuotationsDetails.UniqueID != Guid.Empty && myQuotationsDetails.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myQuotationsDetails.UniqueID = ((myQuotationsDetails.UniqueID != Guid.Empty && myQuotationsDetails.UniqueID != null) ? myQuotationsDetails.UniqueID : Guid.NewGuid());
            if (myQuotationsDetails.Mode == GlobalConfigurations.Mode.Insert)
            {
                myQuotationsDetails.IsActive = true;
                //myQuotationsDetails.IsDeleted = false;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();

            parameters.Add(new SqlParameter("@QuotationsDetailsID", myQuotationsDetails.UniqueID));
            parameters.Add(new SqlParameter("@QuotationsID", myQuotationsDetails.QuotationsID));
            parameters.Add(new SqlParameter("@ProductID", myQuotationsDetails.ProductID));
            parameters.Add(new SqlParameter("@ProductName", (string.IsNullOrEmpty(myQuotationsDetails.ProductName) ? (object)DBNull.Value : myQuotationsDetails.ProductName)));
            parameters.Add(new SqlParameter("@UnitPrice", (myQuotationsDetails.UnitPrice == 0 ? (object)DBNull.Value : myQuotationsDetails.UnitPrice)));
            parameters.Add(new SqlParameter("@OrderPrice", (myQuotationsDetails.OrderPrice == 0 ? (object)DBNull.Value : myQuotationsDetails.OrderPrice)));
            parameters.Add(new SqlParameter("@Quantity", (myQuotationsDetails.Quantity == 0 ? (object)DBNull.Value : myQuotationsDetails.Quantity)));
            parameters.Add(new SqlParameter("@Amount", (myQuotationsDetails.Amount == 0 ? (object)DBNull.Value : myQuotationsDetails.Amount)));
            parameters.Add(new SqlParameter("@SpecialInstruction", (string.IsNullOrEmpty(myQuotationsDetails.SpecialInstruction) ? (object)DBNull.Value : myQuotationsDetails.SpecialInstruction)));
            parameters.Add(new SqlParameter("@CanApplyDiscount", myQuotationsDetails.CanApplyDiscount));
            parameters.Add(new SqlParameter("@Remarks", (string.IsNullOrEmpty(myQuotationsDetails.Remarks) ? (object)DBNull.Value : myQuotationsDetails.Remarks)));
            parameters.Add(new SqlParameter("@QuotationsStatus", (string.IsNullOrEmpty(myQuotationsDetails.QuotationsStatus) ? (object)DBNull.Value : myQuotationsDetails.QuotationsStatus)));
            parameters.Add(new SqlParameter("@IsMiscellaneous", myQuotationsDetails.IsMiscellaneous));
            parameters.Add(new SqlParameter("@CreatedBy", ((myQuotationsDetails.UserAccountID != Guid.Empty && myQuotationsDetails.UserAccountID != null) ? myQuotationsDetails.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myQuotationsDetails.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myQuotationsDetails.IsDeleted));
            parameters.Add(new SqlParameter("@Mode", myQuotationsDetails.Mode));

            SQLHelper.ExecuteQuery("spAddOrUpdateQuotationsDetails", parameters);
        }
    }
}
